/**
 * Generates ../scr/ShaderChunks.js file based on the contents of the ../src/glsl directory
 */

const fs = require('fs');

const jsDstDir = '../src/ShaderChunk.js';
const glslSrcDir = '../src/glsl';
const srcFiles = fs.readdirSync(glslSrcDir);

function generateImports(files) {
  let c = ``;
  
  files.forEach((file) => {
    const name = file.split('.')[0];
    c += `import ${name} from './glsl/${file}';\n`;
  });
  
  return c;
}

function generateExports(files) {
  let c = ``;
  
  files.forEach((file) => {
    const name = file.split('.')[0];
    c += `  ${name}: ${name},\n`;
  });
  
  return c;
}

let output =
`// generated by scripts/build_shader_chunks.js

${generateImports(srcFiles)}

export const ShaderChunk = {
${generateExports(srcFiles)}
};

`;

fs.writeFileSync(jsDstDir, output);
