# Three.js Vite Template with TypeScript
## Mazda RX 7 3D Model loaded to scene
<img width="796" alt="screenshot" src="https://raw.githubusercontent.com/inverser-pro/threejs-typescript-vite/main/public/intro.jpg">

Model downloaded from https://sketchfab.com/3d-models/mazda-rx-7-car-404b2aefdf084f01bc3d75559c9c4088

[Перейти к списку воспроизведения на YouTube](https://www.youtube.com/watch?v=Ph9B6r57Vnk&list=PL0XYm8bdyeFDGJmFeHDiEXsmLfq3vWBaj&index=32)

[CodeSandBox](https://codesandbox.io/p/devbox/github/inverser-pro/threejs-typescript-vite/tree/main/)

# Three.js Vite Template with TypeScript

Three.js + Vite + TypeScript starter

- [Demo](https://vite-threejs-ts-template.vercel.app/)
- [Jump to CLI commands](#cli-commands)

## Copy (clone without git history)

```shell
npx degit pachoclo/vite-threejs-ts-template threejs-project
```

---
---

## Stuff included in the `scene.ts`

- [x] Geometry
- [x] Material
- [x] Mesh
- [x] Ambient Light
- [x] Point Light
- [x] Camera
- [x] Scene
- [x] Canvas
- [x] Renderer (WebGL)
- [x] Loading Manager
- [x] Orbit Controls
- [x] Drag Controls
- [x] Grid
- [x] Antialias enabled
- [x] Transparent canvas
- [x] Responsive renderer and camera (to canvas size)
- [x] Animation Loop
- [x] Shadows
- [x] Stats (FPS, ms)
- [x] Full screen (double-click on canvas)
- [x] Debug GUI

## Tech Stack

- Three.js
- TypeScript
- Vite

## CLI Commands

Installation

```bash
npm i
```

Run dev mode

```bash
npm run dev
```

Build

```bash
npm run build
```

Run build

```bash
npm run preview
```
